package com.javacodegeeks.examples.exceptions;

import java.util.HashMap;
import java.util.Map;

public class NullPointerExceptionDemo {
    public static void main(String[] args) {
        // invoking a method on null causes NullPointerException
        callingMethodOnNull();

        //avoiding NullPointerException while checking equality
        callingMethodOnLiteral();

        //getLength(null);
        getLength("Java Code Geeks");

        Map<String, String> map = new HashMap<>();
        //nullPointerExceptionInMap(map);
        handlingNullPointerExceptionInMap(map);
    }

    private static void callingMethodOnLiteral() {
        // Initializing String variable with null value
        String nullString = null;

        // Checking if "any_string".equals(nullString) or works fine.
        try {
            // This line of code throws NullPointerException
            // because ptr is null
            if ("any_string".equals(nullString))
                System.out.println("Both strings are same.");
            else
                System.out.println("Both strings are not same.");
        } catch (NullPointerException e) {
            System.out.println("NullPointerException occurred");
        }
    }


    private static void callingMethodOnNull() {
        // Initializing String variable with null value
        String nullString = null;

        // Checking if nullString.equals(any_string) or works fine.
        try {
            // This line of code throws NullPointerException
            // because ptr is null
            if (nullString.equals("any_string"))
                System.out.println("Both strings are same.");
            else
                System.out.println("Both strings are not same.");
        } catch (NullPointerException e) {
            System.out.println("NullPointerException occurred");
        }
    }

    public static int getLength(String s) {
        if (s == null)
            throw new IllegalArgumentException("The argument cannot be null");

        return s.length();
    }

    public static void nullPointerExceptionInMap(Map<String, String> map) {

        String key = "1";
        String value = map.get(key);
        System.out.println(value.toString()); // An exception will be thrown, if the value is null.
    }

    public static void handlingNullPointerExceptionInMap(Map<String, String> map) {

        String key = "1";
        if (map.containsKey(key)) {
            String value = map.get(key);
            System.out.println(value.toString()); // No exception will be thrown.
        }
    }

    public static int getLengthWithAssertion(String s) {
        /* Ensure that the String is not null. */
        assert (s != null);

        return s.length();
    }

    public static void handlingNullPointerExceptionWithInstanceOf(Map<String, String> map) {

        String str = null;
        if (str instanceof String)
            System.out.println("It's an instance of the String class!");
        else
            System.out.println("Not an instance of the String class!");
    }

}

